package gov.va.med.domain.service.messaging.parse;
import java.util.Map;

import ca.uhn.hl7v2.model.Structure;
/**
 * Combines the Error and event listening into a single interface and adds 
 *  with a couple of methods necessary for the HL7
 * @author Joel Goldberg
 * @version $Id: IHL7ProcessingParseErrorListener.java,v 1.4 2005/06/22 14:50:01 joel.goldberg Exp $
 * @since MHV 2.0 <br>Jun 20, 2005
 */
public interface IHL7ProcessingParseErrorListener 
						extends IHL7ParseErrorListener {
       
        /**
         * Adds the error to the ErrorsByIen Map after determining the key (e.g. IEN).
         * This method expects the message structure to be built to enable the key 
         * to be extracted.  This means that this method may not work if invoked in 
         * the scope of the parse() method because the message structure has not 
         * been completely built.  
         */
        public void addKeyedError(HL7ParseError error);
        /**
         * Returns a Map of the errors encountered.  The key is
         * a Structure and the value is a List of HL7ParseError subclass instances.
         */
        public Map getErrorsByRootSegment();
        /** 
         * Returns the root segment of the Structure provided. 
         * The root is the base structure that contains all the 
         * child segments that comprise the logical record. \<P> 
         * Used internaly and also by the Decoder to match the 
         * segemnt of the errors with the segment for the DTO when
         * adding it to its DtoListPayload 
         */
        public Structure getRootStructure(Structure structure);
        
     



}
